% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4ListGroup}
\alias{bs4ListGroup}
\alias{bs4ListGroupItem}
\alias{listGroup}
\alias{listGroupItem}
\title{BS4 list group for AdminLTE3}
\usage{
bs4ListGroup(
  ...,
  type = c("basic", "action", "heading"),
  width = 4,
  .list = NULL
)

bs4ListGroupItem(
  ...,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  active = FALSE,
  disabled = FALSE,
  href = NULL
)

listGroup(..., type = c("basic", "action", "heading"), width = 4, .list = NULL)

listGroupItem(
  ...,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  active = FALSE,
  disabled = FALSE,
  href = NULL
)
}
\arguments{
\item{...}{Item content.}

\item{type}{List group type.}

\item{width}{List group width. 4 by default. Between 1 and 12.}

\item{.list}{Slot for programmatically generated items.}

\item{title}{Item title (only if type is "heading").}

\item{subtitle}{Item subtitle (only if type is "heading").}

\item{footer}{Item footer content (only if type is "heading").}

\item{active}{Whether the item is active or not. FALSE by default.
Only if type is "action" or "heading".}

\item{disabled}{Whether the item is disabled or not. FALSE by default.
Only if type is "action" or "heading".}

\item{href}{Item external link.}
}
\description{
Create a list group

Create a list group item
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     controlbar = dashboardControlbar(),
     footer = dashboardFooter(),
     title = "test",
     body = dashboardBody(
      fluidRow(
       listGroup(
        type = "basic",
        listGroupItem("Cras justo odio"),
        listGroupItem("Dapibus ac facilisis in"),
        listGroupItem("Morbi leo risus")
       ),
       listGroup(
        type = "action",
        listGroupItem(
         "Cras justo odio",
         active = TRUE,
         disabled = FALSE,
         href = "https://www.google.com"
        ),
        listGroupItem(
         active = FALSE,
         disabled = FALSE,
         "Dapibus ac facilisis in",
         href = "https://www.google.com"
        ),
        listGroupItem(
         "Morbi leo risus",
         active = FALSE,
         disabled = TRUE,
         href = "https://www.google.com"
        )
       ),
       listGroup(
        type = "heading",
        listGroupItem(
         "Donec id elit non mi porta gravida at eget metus.
         Maecenas sed diam eget risus varius blandit.",
         active = TRUE,
         disabled = FALSE,
         title = "List group item heading",
         subtitle = "3 days ago",
         footer = "Donec id elit non mi porta."
        ),
        listGroupItem(
         "Donec id elit non mi porta gravida at eget metus.
         Maecenas sed diam eget risus varius blandit.",
         active = FALSE,
         disabled = FALSE,
         title = "List group item heading",
         subtitle = "3 days ago",
         footer = "Donec id elit non mi porta."
        )
       )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
