% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-github.R
\name{btw_tool_github}
\alias{btw_tool_github}
\title{Tool: GitHub}
\usage{
btw_tool_github(code, fields = "default", `_intent` = "")
}
\arguments{
\item{code}{R code that calls \code{gh()} or \code{gh_whoami()}. The code will be
evaluated in an environment where \code{owner} and \code{repo} variables are
predefined (defaulting to the current repository if detected). The \code{gh()}
function is available without needing to load the gh package.}

\item{fields}{Optional character vector of GitHub API response fields to
retain. If provided, only these fields will be included in the result.
Defaults to a curated set of commonly used fields.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A \code{btw_tool_result} containing the result of the GitHub API call.
}
\description{
Execute R code that calls the GitHub API using \code{\link[gh:gh]{gh::gh()}}.

This tool is
designed such that models can write very limited R code to call \code{\link[gh:gh]{gh::gh()}}
and protections are inserted to prevent the model from calling unsafe or
destructive actions via the API. The \strong{Endpoint Validation} section below
describes how API endpoints are validated to ensure safety.

While this tool \emph{can} execute R code, the code is evaluated in an environment
where only a limited set of functions and variables are available. In
particular, only the \code{gh()} and \code{gh_whoami()} functions from the \code{gh} package
are available, along with \code{owner} and \code{repo} variables that are pre-defined
to point to the current repository (if detected). This allows models to focus
on writing GitHub API calls without needing to load packages or manage
authentication.
\subsection{Endpoint Validation}{

This tool uses endpoint validation to ensure only safe GitHub API operations
are performed. By default, most read operations and low-risk write operations
(like creating issues or PRs) are allowed, while dangerous operations (like
merging PRs or deleting repositories) are blocked.

To customize which endpoints are allowed or blocked, use the
\code{btw.github.allow} and \code{btw.github.block} options:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Allow a specific endpoint
options(btw.github.allow = c(
  getOption("btw.github.allow"),
  "GET /repos/*/*/topics"
))

# Block a specific endpoint
options(btw.github.block = c(
  getOption("btw.github.block"),
  "GET /repos/*/*/branches"
))
}\if{html}{\out{</div>}}

You can also set these options in your \link[=use_btw_md]{btw.md} file under the
\code{options} field:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{tools: github
options:
  github:
    allow:
      - "PATCH /repos/*/*/pulls/*" # Allow converting PRs to/from draft
      - "POST /repos/*/*/git/refs" # Allow creating branches
    block:
      - "DELETE /repos/**" # Block any delete action under /repos
}\if{html}{\out{</div>}}

The precedence order for rules is:
\enumerate{
\item User block rules (checked first, highest priority)
\item User allow rules
\item Built-in block rules
\item Built-in allow rules
\item Default: reject (if no rules match)
}
}

\subsection{Additional Examples}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Get an issue
btw_tool_github(
  code = 'gh("/repos/\{owner\}/\{repo\}/issues/123", owner = owner, repo = repo)'
)

# Create an issue
btw_tool_github(code = r"(
  gh(
    "POST /repos/\{owner\}/\{repo\}/issues",
    title = \\"Bug report\\",
    body = \\"Description of bug\\",
    owner = owner,
    repo = repo
  )
)")

# Target a different repository
btw_tool_github(code = 'gh("/repos/tidyverse/dplyr/issues/123")')
}\if{html}{\out{</div>}}
}
}
\examples{
# This tool requires the gh package and authentication to GitHub.
# See additional examples in the documentation above.

}
\concept{github tools}
