% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CARAEE_Alloc_Surv}
\alias{CARAEE_Alloc_Surv}
\title{Allocation Function of CARA Designs Based on Efficiency and Ethics for Survival Response}
\usage{
CARAEE_Alloc_Surv(
  ptsb.cov,
  ptsb.t,
  ptsb.Y,
  ptsb.E,
  ptnow.cov,
  gamma,
  event.prob
)
}
\arguments{
\item{ptsb.cov}{a \code{n x k} covariate matrix of previous patients.}

\item{ptsb.t}{a treatment vector of previous patients with length \code{n}.}

\item{ptsb.Y}{a response vector of previous patients with length \code{n}.}

\item{ptsb.E}{a censoring indicator vector (1 = event observed, 0 = censored)with length \code{n}.}

\item{ptnow.cov}{a covariate vector of the incoming patient with length \code{k}.}

\item{gamma}{a non-negative number. A tuning parameter that reflects the importance of the efficiency component compared to the ethics component.}

\item{event.prob}{a vector with length 2. The probability of events of upcoming patient for two treatments.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses
using CARA Designs Based on Efficiency and Ethics for survival trial.
}
\examples{
set.seed(123)
n = 40
covariates = cbind(rexp(40),rexp(40))
treatment = sample(c(0, 1), n, replace = TRUE)
survival_time = rexp(n, rate = 1)
censoring = runif(n)
event = as.numeric(survival_time < censoring)

new_patient_cov = c(Z1 = 1, Z2 = 0.5)

result = CARAEE_Alloc_Surv(
 ptsb.cov = covariates,
 ptsb.t = treatment,
 ptsb.Y = survival_time,
 ptsb.E = event,
 ptnow.cov = new_patient_cov,
 gamma=1,
 event.prob = c(0.5,0.7)
)
print(result$prob)
}
\concept{CARAEE Design}
