% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_records}
\alias{cfbd_game_records}
\title{\strong{Get team records by year}}
\usage{
cfbd_game_records(year, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{conference}{(\emph{String} optional): DI Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_game_records]{cfbd_game_records()}} - A data frame with 35 variables:
\describe{
\item{\code{year}: integer.}{Season of the games.}
\item{\code{team_id}: integer.}{Referencing team id.}
\item{\code{team}: character.}{Team name.}
\item{\code{classification}: character}{Conference classification (fbs,fcs,ii,iii)}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{division}: character.}{Division in the conference of the team.}
\item{\code{expected_wins}: numeric}{Expected number of wins based on post-game win probability.}
\item{\code{total_games}: integer.}{Total number of games played.}
\item{\code{total_wins}: integer.}{Total wins.}
\item{\code{total_losses}: integer.}{Total losses.}
\item{\code{total_ties}: integer.}{Total ties.}
\item{\code{conference_games}: integer.}{Number of conference games.}
\item{\code{conference_wins}: integer.}{Total conference wins.}
\item{\code{conference_losses}: integer.}{Total conference losses.}
\item{\code{conference_ties}: integer.}{Total conference ties.}
\item{\code{home_games}: integer.}{Total home games.}
\item{\code{home_wins}: integer.}{Total home wins.}
\item{\code{home_losses}: integer.}{Total home losses.}
\item{\code{home_ties}: integer.}{Total home ties.}
\item{\code{away_games}: integer.}{Total away games.}
\item{\code{away_wins}: integer.}{Total away wins.}
\item{\code{away_losses}: integer.}{Total away losses.}
\item{\code{away_ties}: integer.}{Total away ties.}
\item{\code{neutral_games}: integer.}{Total neutral site games.}
\item{\code{neutral_wins}: integer.}{Total neutral site wins.}
\item{\code{neutral_losses}: integer.}{Total neutral site losses.}
\item{\code{neutral_ties}: integer.}{Total neutral site ties.}
\item{\code{regular_season_games}: integer.}{Total regular season games.}
\item{\code{regular_season_wins}: integer.}{Total regular season wins.}
\item{\code{regular_season_losses}: integer.}{Total regular season losses.}
\item{\code{regular_season_ties}: integer.}{Total regular season ties.}
\item{\code{postseason_games}: integer.}{Total postseason games.}
\item{\code{postseason_wins}: integer.}{Total postseason wins.}
\item{\code{postseason_losses}: integer.}{Total postseason losses.}
\item{\code{postseason_ties}: integer.}{Total postseason ties.}
}
}
\description{
\strong{Get team records by year}
}
\examples{
\donttest{
  try(cfbd_game_records(2018, team = "Notre Dame"))

  try(cfbd_game_records(2013, team = "Florida State"))
}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_game_weather}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
\keyword{Info}
\keyword{Team}
