% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R, R/orderfast.R
\name{orderfast}
\alias{orderfast}
\title{Fast Ordering Function}
\usage{
orderfast(df)
}
\arguments{
\item{df}{A dataframe with 'id' and 'time' columns}
}
\value{
A dataframe ordered by id and time

A dataframe ordered by id and time
}
\description{
Orders a dataframe by \code{id} and \code{time} columns efficiently using base R's
\code{order}. Optimized for large CGM datasets, it returns the input with rows
sorted by subject then timestamp while preserving all columns.

Orders a dataframe by id and time columns
}
\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Shuffle without replacement, then order and compare to baseline
set.seed(123)
shuffled <- example_data_5_subject[sample(seq_len(nrow(example_data_5_subject)),
                                          replace = FALSE), ]
baseline <- orderfast(example_data_5_subject)
ordered_shuffled <- orderfast(shuffled)

# Compare results
print(paste("Identical after ordering:", identical(baseline, ordered_shuffled)))
head(baseline[, c("id", "time", "gl")])
head(ordered_shuffled[, c("id", "time", "gl")])

# Order larger dataset
ordered_large <- orderfast(example_data_hall)
print(paste("Ordered", nrow(ordered_large), "rows in larger dataset"))
df <- data.frame(id = c("b", "a", "a"), time = as.POSIXct(
  c("2024-01-01 01:00:00", "2024-01-01 00:00:00", "2024-01-01 01:00:00"), tz = "UTC"
))
orderfast(df)
}
