% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_make_h3}
\alias{par_make_h3}
\title{Convert H3 indices to sf object}
\usage{
par_make_h3(x, res = 5L)
}
\arguments{
\item{x}{sf object.}

\item{res}{integer(1). H3 resolution. Default is 5L.}
}
\value{
An \code{sf} object with polygons representing the H3 indices.
}
\description{
This function converts an input \code{sf} to an
\code{sf} object with H3 hexagons.
It requires the \code{h3r} package to be installed.
}
\details{
Non-polygon \code{x} will be converted to polygons using
\code{\link[sf:geos_unary]{sf::st_concave_hull}}. If the input is not convertible
to polygons, the function will throw an error.
}
\examples{
lastpar <- par(mfrow = c(1, 1))
library(sf)
if (rlang::is_installed("h3r")) {
library(h3r)
options(sf_use_s2 = FALSE)
ncpath <- system.file("shape/nc.shp", package = "sf")
nc <- read_sf(ncpath)
nc <- st_transform(nc, "EPSG:4326")
# note that it will throw a warning if
# the input is MULTIPOLYGON.
nc_comp_region_h3 <-
  suppressWarnings(
    par_make_h3(
      nc,
      res = 5L
    )
  )
plot(sf::st_geometry(nc_comp_region_h3))
}
par(lastpar)
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_dggrid}()},
\code{\link{par_make_grid}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_balanced}()},
\code{\link{par_pad_grid}()},
\code{\link{par_split_list}()}
}
\author{
Insang Song
}
\concept{Parallelization}
