% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_get_geocode}
\alias{enhancements_get_geocode}
\title{Get a Geocode Enhancement}
\usage{
enhancements_get_geocode(id)
}
\arguments{
\item{id}{integer required.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{remoteHostId}{integer, The ID of the remote host.}
\item{credentialId}{integer, The ID of the remote host credential.}
\item{sourceSchemaAndTable}{string, The source database schema and table.}
\item{multipartKey}{array, The source table primary key.}
\item{limitingSQL}{string, The limiting SQL for the source table. "WHERE" should be omitted (e.g. state='IL').}
\item{targetSchema}{string, The output table schema.}
\item{targetTable}{string, The output table name.}
\item{country}{string, The country of the addresses to be geocoded; either 'us' or 'ca'.}
\item{provider}{string, The geocoding provider; one of postgis and geocoder_ca.}
\item{outputAddress}{boolean, Whether to output the parsed address. Only guaranteed for the 'postgis' provider.}
\item{archived}{string, The archival status of the requested item(s).}
\item{parentId}{integer, Parent ID that triggers this enhancement.}
}
\description{
Get a Geocode Enhancement
}
