% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{notebooks_list}
\alias{notebooks_list}
\title{List Notebooks}
\usage{
notebooks_list(
  hidden = NULL,
  archived = NULL,
  author = NULL,
  status = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{author}{string optional. If specified, return items from any of these authors. It accepts a comma-separated list of user IDs.}

\item{status}{string optional. If specified, returns notebooks with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'pending', 'idle'.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this notebook.}
\item{name}{string, The name of this notebook.}
\item{language}{string, The kernel language of this notebook ("python3" or "r"). Defaults to "python3".}
\item{description}{string, The description of this notebook.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{mostRecentDeployment}{list, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment, in MB.
\item cpu integer, The cpu allocated to the deployment, in millicores.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item maxMemoryUsage number, If the deployment has finished, the maximum amount of memory used during the deployment, in MB.
\item maxCpuUsage number, If the deployment has finished, the maximum amount of cpu used during the deployment, in millicores.
\item createdAt string, 
\item updatedAt string, 
\item notebookId integer, The ID of the owning Notebook
}}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List Notebooks
}
