% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{cloudml_train}
\alias{cloudml_train}
\title{Train a model using Cloud ML}
\usage{
cloudml_train(
  file = "train.R",
  master_type = NULL,
  flags = NULL,
  region = NULL,
  config = NULL,
  collect = "ask",
  dry_run = FALSE
)
}
\arguments{
\item{file}{File to be used as entrypoint for training.}

\item{master_type}{Training master node machine type. "standard" provides a
basic machine configuration suitable for training simple models with small
to moderate datasets. See the documentation at
\url{https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec}
for details on available machine types.}

\item{flags}{Named list with flag values (see \code{\link[tfruns:flags]{flags()}}) or path
to YAML file containing flag values.}

\item{region}{The region to be used for training.}

\item{config}{A list, \code{YAML} or \code{JSON} configuration file as described
\url{https://cloud.google.com/vertex-ai}.}

\item{collect}{Logical. If TRUE, collect job when training is completed
(blocks waiting for the job to complete). The default (\code{"ask"}) will
interactively prompt the user whether to collect the results or not.}

\item{dry_run}{Triggers a local dry run over the deployment phase to
validate packages and packing work as expected.}
}
\description{
Upload a TensorFlow application to Google Cloud, and use that application to
train a model.
}
\examples{
\dontrun{
library(cloudml)

gcloud_install()
job <- cloudml_train("train.R")
}

}
\seealso{
\code{\link[=job_status]{job_status()}}, \code{\link[=job_collect]{job_collect()}}, \code{\link[=job_cancel]{job_cancel()}}

Other CloudML functions: 
\code{\link{cloudml_deploy}()},
\code{\link{cloudml_predict}()}
}
\concept{CloudML functions}
