% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{glmnet.funs}
\alias{glmnet.funs}
\alias{elastic.funs}
\alias{lasso.funs}
\alias{ridge.funs}
\title{Elastic net, lasso, ridge regression training and prediction functions.}
\usage{
elastic.funs(
  gamma = 0.5,
  standardize = TRUE,
  intercept = TRUE,
  lambda = NULL,
  nlambda = 50,
  lambda.min.ratio = 1e-04,
  cv.rule = c("min", "1se")
)

lasso.funs(
  standardize = TRUE,
  intercept = TRUE,
  lambda = NULL,
  nlambda = 50,
  lambda.min.ratio = 1e-04,
  cv.rule = c("min", "1se")
)

ridge.funs(
  standardize = TRUE,
  intercept = TRUE,
  lambda = NULL,
  nlambda = 50,
  lambda.min.ratio = 1e-04,
  cv.rule = c("min", "1se")
)
}
\arguments{
\item{gamma}{Mixing parameter (between 0 and 1) for the elastic net, where
0 corresponds to ridge regression, and 1 to the lasso. Default is 0.5.}

\item{standardize, intercept}{Should the data be standardized, and should an
intercept be included? Default for both is TRUE.}

\item{lambda}{Sequence of lambda values over which training is performed.
This must be in decreasing order, and --- this argument should be used with
caution! When used, it is usually best to grab the sequence constructed by
one initial call to glmnet (see examples). Default is NULL, which means that
the nlambda, lambda.min.ratio arguments will define the lambda sequence
(see next).}

\item{nlambda}{Number of lambda values over which training is performed. In
particular, the lambda sequence is defined by nlambda log-spaced values
between lambda.max and lambda.min.ratio * lambda.max, where lambda.max is
the smallest value of lambda at which the solution has all zero components,
and lambda.min.ratio is a small fraction (see next). Default is 50.}

\item{lambda.min.ratio}{Small fraction that gets used in conjunction with
nlambda to specify a lambda sequence (see above). Default is 1e-4.}

\item{cv.rule}{If the cv argument is TRUE, then cv.rule determines which rule
should be used for the predict function, either "min" (the usual rule) or
"1se" (the one-standard-error rule). See the glmnet help files for details.
Default is "min".}
}
\value{
A list with three components: train.fun, predict.fun, active.fun.
  The third function is designed to take the output of train.fun, and
  reports which features are active for each fitted model contained in
  this output.
}
\description{
Construct training and prediction functions for the elastic net, the lasso,
or ridge regression, based on the \code{\link[glmnet]{glmnet}} package, over a
sequence of (given or internally computed) lambda values.
}
\details{
This function is based on the package \code{\link[glmnet]{glmnet}}.
  Notice that Cross Validation to select the best lambda value is compulsory!
  The functions lasso.funs and ridge.funs are convenience
  functions, they simply call elastic.funs with gamma = 1 and gamma = 0,
  respectively.
}
