% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conts_datasources.R
\name{write_datasources}
\alias{write_datasources}
\title{Write datasources attribute into a config file}
\usage{
write_datasources(connectors, file)
}
\arguments{
\item{connectors}{A connectors object with associated "datasources"
attribute.}

\item{file}{path to the config file}
}
\value{
A config file with datasource attributes which can be reused in the
connect function
}
\description{
Reproduce your workflow by creating a config file based on a connectors
object and the associated datasource attributes.
}
\examples{
folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connectors(fs = connector_fs(folder))

# Extract the datasources to a config file
yml_file <- tempfile(fileext = ".yml")
write_datasources(cnt, yml_file)
# Check the content of the file
cat(readLines(yml_file), sep = "\n")
# Reconnect using the new config file
re_connect <- connect(yml_file)
re_connect
}
