% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_estimates_and_CIs_stratified_2x2.R
\name{ML_estimates_and_CIs_stratified_2x2}
\alias{ML_estimates_and_CIs_stratified_2x2}
\title{Maximum likelihood estimates with CIs of the grouping and strata effects}
\usage{
ML_estimates_and_CIs_stratified_2x2(n, link = "log", alpha = 0.05)
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{link}{the link function ('linear', 'log', or 'logit')}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
Maximum likelihood estimates with CIs of the grouping and strata effects

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
ML_estimates_and_CIs_stratified_2x2(doll_hill_1950)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
ML_estimates_and_CIs_stratified_2x2(hine_1989)

}
