% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_sequential.R
\name{crew_controller_sequential}
\alias{crew_controller_sequential}
\title{Create a sequential controller.}
\usage{
crew_controller_sequential(
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE
)
}
\arguments{
\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to detach any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.
In either case, the namespaces are not detached.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.
for this and other reasons, \code{reset_options} only resets options
that were nonempty at the beginning of the task.
If your task sets an entirely new option not already in \code{options()},
then \code{reset_options = TRUE} does not delete the option.}

\item{garbage_collection}{\code{TRUE} to run garbage collection after each task
task, \code{FALSE} to skip.}
}
\description{
The sequential controller runs tasks on the same R process
where the controller object exists. Tasks run sequentially
rather than in parallel.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_sequential()
controller$push(name = "task", command = sqrt(4))
controller$pop()
}
}
\seealso{
Other sequential controllers: 
\code{\link{crew_class_controller_sequential}}
}
\concept{sequential controllers}
