% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowwise.R
\name{rowDistinct}
\alias{rowDistinct}
\alias{straightlineResponse}
\title{Create variables useful for determining whether a row's values are suspicious}
\usage{
rowDistinct(x, name, ..., na.rm = TRUE)

straightlineResponse(x, name, ...)
}
\arguments{
\item{x}{A \code{CrunchVariable}that is an an array, that unique values should be counted across.}

\item{name}{a character to use as the name of the case variable to create}

\item{...}{Optional attributes, like \code{description}, to set on the new variable (passed to
\code{VarDef()})}

\item{na.rm}{Whether to count missing data as a separate category (all missing categories will
be lumped together)}
}
\value{
A Variable Definition, which can be used to create a new \code{CrunchVariable}
}
\description{
\code{rowDistinct()} finds the number of unique values given per row of variables in an array
\code{CrunchVariable}. \code{straightlineResponse()} returns a \code{selection} variable that indicates
whether the responses are identical. When a row has all columns that are missing of the
same type, it will return \code{Selected}, but will missing if any other number of values is missing
(or there are multiple types of missing).
}
\seealso{
\code{\link[=rowCount]{rowCount()}} for other row-wise functions
}
