% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_tktd.R
\name{fit_tktd}
\alias{fit_tktd}
\alias{fit_tktd,ANY,ANY-method}
\alias{fit_tktd,list,missing-method}
\alias{fit_tktd,cvasi_fit,ANY-method}
\alias{fit_tktd,CalibrationSet,ANY-method}
\alias{fit_tktd,CalibrationSet,missing-method}
\alias{fit_tktd,EffectScenario,ANY-method}
\alias{fit_tktd,ScenarioSequence,ANY-method}
\alias{fit_tktd,LemnaSetac,missing-method}
\alias{fit_tktd,LemnaSchmitt,missing-method}
\alias{fit_tktd,Magma,missing-method}
\title{Fit TK/TD parameters}
\usage{
fit_tktd(x, data, ...)

\S4method{fit_tktd}{LemnaSetac,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)

\S4method{fit_tktd}{LemnaSchmitt,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)

\S4method{fit_tktd}{Magma,missing}(x, data, par, log_scale = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{x}{a \link{scenario} or a list of \link{caliset} objects}

\item{data}{toxicological trial data to fit TK/TD parameters to: required if
\code{x} is either a \link{scenario} or the result of a fit. See Section \emph{Data}
for details.}

\item{...}{additional arguments passed through to \code{\link[=calibrate]{calibrate()}}}

\item{par}{named vector, of parameters to fit and their starting values}

\item{log_scale}{logical, if \code{TRUE} then fitting will be performed on log-transformed
observations and predictions, else the data will be used as-is}

\item{verbose}{logical, if \code{TRUE} then info messages are printed to the console}
}
\value{
a list
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
\subsection{Data}{

The function can be used in three basic ways: Fit parameters of
\enumerate{
\item a single \link{scenario} to a data set
\item a list of \link{caliset}s
\item a list of \link{caliset}s in a chain of \code{fit} functions
}

For option 1), scenario and data are supplied separately. In this case,
supported types of argument \code{data} are \code{data.frame}s and \link{tox_data} objects.
Any \code{data.frame} must have a format that is compatible with the \code{\link[=tox_data]{tox_data()}}
function.

In option 2), all conditions are fully described by a list of calibration sets.
The user is responsible to set up all \link{caliset} objects to their needs.

Option
3) is for convenience purposes and allows the chaining of fit functions.
The latter alternative accepts the return value of e.g. \code{\link[=fit_growth]{fit_growth()}}
as argument \code{x} and the fitted parameter values are applied to all
calibration sets in argument \code{data}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{fit_tktd(x = LemnaSetac, data = missing)}: Fit TK/TD parameters of \link{Lemna_SETAC} scenarios

\item \code{fit_tktd(x = LemnaSchmitt, data = missing)}: Fit TK/TD parameters of \link{Lemna_Schmitt} scenarios

\item \code{fit_tktd(x = Magma, data = missing)}: Fit TK/TD parameters of \link{Magma} scenarios

}}
\examples{
# Use experimental data from control trial ('T0') to fit growth rate
ctrl <- schmitt2013[schmitt2013$trial == "T0" ,]

# Set up a scenario, provide dummy parameter values where necessary
sc <- Lemna_Schmitt() \%>\%
  set_init(c(BM=0.0012)) \%>\%
  set_param(c(EC50=1, b=1, P_up=1))

# Run fitting routine
fit_growth(sc, data=ctrl, verbose=TRUE)

# Use fitted growth parameter to adapt scenario
sc2 <- sc \%>\% set_param(c(k_phot_max=0.43925))

# Use experimental ecotox data for various concentrations of 'metsulfuron-methyl'
trials <- schmitt2013[schmitt2013$trial != "T0" ,]

# Fit remaining TK/TD parameters
fit_tktd(sc2, data=trials, verbose=TRUE)
}
