% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_fss.R
\name{fs_fss}
\alias{fs_fss}
\title{Forward Stepwise Selection}
\usage{
fs_fss(attribute)
}
\arguments{
\item{attribute}{Character. Name of the target variable.}
}
\value{
A \code{fs_fss} object.
}
\description{
Greedy feature selection that iteratively adds the feature which most improves the
model according to an adjustment metric (e.g., adjusted R^2). Wraps \code{leaps::regsubsets}.
}
\examples{
\dontrun{
data(iris)

# 1) Forward stepwise for numeric response (adjusted R^2 criterion)
fs <- daltoolbox::fit(fs_fss("Sepal.Length"), iris)
fs$features

# 2) Subset to selected features + target
data_fss <- daltoolbox::transform(fs, iris)
head(data_fss)
}
}
\references{
Hastie, T., Tibshirani, R., & Friedman, J. (2009). The Elements of Statistical Learning.
}
