% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importWaterML1.R
\name{importWaterML1}
\alias{importWaterML1}
\title{Function to return data from the NWISWeb WaterML1.1 service}
\usage{
importWaterML1(obs_url, asDateTime = FALSE, tz = "UTC")
}
\arguments{
\item{obs_url}{character or raw, containing the url for the retrieval or a
file path to the data file, or raw XML.}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, Date}

\item{tz}{character to set timezone attribute of datetime. Default converts the datetimes to UTC
(properly accounting for daylight savings times based on the data's provided tz_cd column).
Recommended US values include "UTC", "America/New_York", "America/Chicago", "America/Denver",
"America/Los_Angeles", "America/Anchorage", "America/Honolulu", "America/Jamaica", "America/Managua",
"America/Phoenix", and "America/Metlakatla".
For a complete list, see \url{https://en.wikipedia.org/wiki/List_of_tz_database_time_zones}}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
\tab POSIXct \tab The date and time of the value converted to UTC (if asDateTime = TRUE), \cr
\tab character \tab or raw character string (if asDateTime = FALSE) \cr
tz_cd \tab character \tab The time zone code for  \cr
code \tab character \tab Any codes that qualify the corresponding value\cr
value \tab numeric \tab The numeric value for the parameter \cr
}
Note that code and value are repeated for the parameters requested. The names are of the form
X_D_P_S, where X is literal,
D is an option description of the parameter,
P is the parameter code,
and S is the statistic code (if applicable).

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
variableInfo \tab data.frame \tab A data frame containing information on the requested parameters \cr
statisticInfo \tab data.frame \tab A data frame containing information on the requested statistics on the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
}
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
site_id <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- "00003"
property <- "00060"
obs_url <- constructNWISURL(site_id, property, startDate, endDate, "dv")
\donttest{
data <- importWaterML1(obs_url, asDateTime = TRUE)


unitDataURL <- constructNWISURL(
  site_id, property,
  "2013-11-03", "2013-11-03", "uv"
)
unitData <- importWaterML1(unitDataURL, TRUE)

# Two sites, two pcodes, one site has two data descriptors:
siteNumber <- c("01480015", "04085427")
obs_url <- constructNWISURL(
  siteNumber, c("00060", "00010"),
  startDate, endDate, "dv"
)
data <- importWaterML1(obs_url)
data$dateTime <- as.Date(data$dateTime)
data <- renameNWISColumns(data)
names(attributes(data))
attr(data, "url")
attr(data, "disclaimer")

inactiveSite <- "05212700"
inactiveSite <- constructNWISURL(inactiveSite, "00060", 
                                 "2014-01-01", "2014-01-10", "dv")
inactiveSite <- importWaterML1(inactiveSite)

inactiveAndAcitive <- c("07334200", "05212700")
inactiveAndAcitive <- constructNWISURL(inactiveAndAcitive, 
                         "00060", "2014-01-01", "2014-01-10", "dv")
inactiveAndAcitive <- importWaterML1(inactiveAndAcitive)

# Timezone change with specified local timezone:
tzURL <- constructNWISURL("04027000", c("00300", "63680"), 
                          "2011-11-05", "2011-11-07", "uv")
tzIssue <- importWaterML1(tzURL,
  asDateTime = TRUE, tz = "America/Chicago"
)

}
filePath <- system.file("extdata", package = "dataRetrieval")
fileName <- "WaterML1Example.xml"
fullPath <- file.path(filePath, fileName)
importFile <- importWaterML1(fullPath, TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=renameNWISColumns]{renameNWISColumns()}}
}
