% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CloneProject.R
\name{CloneProject}
\alias{CloneProject}
\title{Clone a project}
\usage{
CloneProject(project, newProjectName = NULL, maxWait = 600)
}
\arguments{
\item{project}{dataRobotProject, or a character representing that project's ID.}

\item{newProjectName}{character. The name of the newly cloned project. If no
name is given, the API will default to 'Copy of \code{project$projectName}'.}

\item{maxWait}{integer. The maximum time to wait for each of two steps: (1) The initial
project creation request, and (2) data processing that occurs after receiving the response
to this initial request.}
}
\value{
A named list that contains:
\describe{
  \item{projectName}{character. The name assigned to the DataRobot project}
  \item{projectId}{character. The unique alphanumeric project identifier for this DataRobot
    project}
  \item{fileName}{character. The name of the CSV modeling file uploaded for this project}
  \item{created}{character. The time and date of project creation}
}
}
\description{
This function clones a project, creating a fresh (post-EDA1) copy that will
need a target and modeling options set.
}
\examples{
\dontrun{
 project <- GetProject("5c1303269300d900016b41a7")
 CloneProject(project, newProjectName = "Project Restart")
}
}
