% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_output.R
\name{format_output}
\alias{format_output}
\title{Format distance or similarity matrix output}
\usage{
format_output(
  dist_mat,
  output_format,
  similarity = FALSE,
  similarity_transform = "linear"
)
}
\arguments{
\item{dist_mat}{A symmetric matrix of pairwise distances.}

\item{output_format}{Character string specifying output format:
\code{"matrix"}, \code{"dist"}, or \code{"similarity"}.}

\item{similarity}{Logical; if \code{TRUE}, converts distances to similarities.}

\item{similarity_transform}{Character string; either \code{"linear"} (default) or \code{"sqrt"}.}
}
\value{
A matrix or `dist` object, depending on the selected format and similarity flag.
}
\description{
Converts a distance matrix to either a similarity matrix or a `dist` object,
depending on user preferences.
}
\details{
When converting to similarity, two transformation formulas are supported to derive
similarity from distance:

\describe{
  \item{\code{"linear", (default)}}{
    \deqn{\text{s}_{ij} = 1 - \delta_{ij}}
    This transformation directly inverts the distance into a similarity score.
  }
  \item{\code{"sqrt"}}{
    \deqn{\text{s}_{ij} = 1 - \delta_{ij}^2}
    This corresponds to a transformation from a metric that satisfies the Euclidean property:
    \deqn{\delta_{ij} = \sqrt{1 - s_{ij}}}
    According to \insertCite{gower1986metric}{dbrobust}, this transformation yields a metric that is
    more likely to preserve Euclidean structure in downstream analyses.
  }
}
}
\references{
\insertRef{gower1986metric}{dbrobust}
}
\keyword{internal}
