% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{ddm-class}
\alias{ddm-class}
\alias{setDDM}
\title{An S4 Class Representing a Decision Diffusion Model}
\usage{
setDDM(model, population_distribution = NULL)
}
\arguments{
\item{model}{A required \code{model} object defining the model
specification.}

\item{population_distribution}{Optional A population-level prior
distribution, typically constructed with \code{BuildPrior}. This argument
enables simulations of subject-level parameters. Default is \code{NULL}.}
}
\value{
An object of S4 class \code{ddm}, which includes:
\itemize{
\item \code{model}: the model specification
\item \code{population_distribution}: the prior distribution (if provided)
}
}
\description{
The \code{ddm} class represents a complete Decision Diffusion Model
(DDM) specification. It encapsulates a \code{model} objects from
the \pkg{ggdmcModel} package, and optionally a population distribution
created via the \code{BuildPrior} function from the \pkg{ggdmcPrior}
package.
}
\details{
The constructor function \code{setDDM} creates a \code{ddm} object by
wrapping the model and optionally a population distribution into a single
structure. This class is designed for compatibility with sampling and
simulation functions within the \pkg{ggdmc} ecosystem.
}
\section{Slots}{

\describe{
\item{\code{model}}{A \code{model} object from \pkg{ggdmcModel} package
that defines the DDM structure, including parameter names, mapping,
and data attributes.}

\item{\code{population_distribution}}{An optional prior distribution, typically
created via \code{BuildPrior} from the \pkg{ggdmcPrior} package. This
slot is primarily used for parameters or hierarchical modelling and can
be \code{NULL}.}
}}

\seealso{
\code{\link[ggdmcModel]{model-class}}, \code{\link[ggdmcPrior]{BuildPrior}}
}
