% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distributions.R
\name{plot_distributions}
\alias{plot_distributions}
\title{Probability distribution plots for various types of Monte Carlo simulation results}
\usage{
plot_distributions(
  mcSimulation_object,
  vars,
  method = "smooth_simple_overlay",
  bins = 150,
  binwidth = NULL,
  old_names = NULL,
  new_names = NULL,
  colors = NULL,
  outlier_shape = ".",
  x_axis_name = "Outcome distribution",
  y_axis_name = NULL,
  base_size = 11,
  ...
)
}
\arguments{
\item{mcSimulation_object}{is an object of Monte Carlo simulation outputs from the \code{\link[decisionSupport:mcSimulation]{mcSimulation}} function}

\item{vars}{is a vector containing variable names from the \code{mcSimulation_object}. This can also be a single variable name}

\item{method}{is the plot option to be used in \code{link{ggplot2}}: "smooth_simple_overlay" creates a density plot with \code{\link[ggplot2:geom_density]{geom_density}}, "hist_simple_overlay" creates a histogram with \code{\link[ggplot2:geom_histogram]{geom_histogram}}, "boxplot" creates a boxplot with \code{\link[ggplot2:geom_boxplot]{geom_boxplot}} and "boxplot_density" creates a density plot with a boxplot using \code{\link[ggplot2:geom_density]{geom_density}} and \code{\link[ggplot2:geom_boxplot]{geom_boxplot}}}

\item{bins}{are the number of bins to use for the \code{\link[ggplot2:geom_histogram]{geom_histogram}}. Default number of bins is 150}

\item{binwidth}{is the width of the bins to use for the \code{\link[ggplot2:geom_histogram]{geom_histogram}}. Default number is 1000. When both \code{bins} and \code{binwidth} are defined, the later overrides \code{bins}}

\item{old_names}{are the variable names from the MC simulation outputs that refer to the distribution values. This should be a vector of character strings. This is set to NULL with the assumption that the existing names for variables are preferred}

\item{new_names}{are the variable names to replace the MC simulation outputs that refer to the distribution values. This should be a vector of character strings. This is set to NULL with the assumption that the existing names for variables are preferred}

\item{colors}{is the color palette to be used for the fill of distribution shapes and boxplots. The default is c("#009999", "#0000FF", "#56B4E9", "#009E73","#F0E442", "#0072B2", "#D55E00", "#CC79A7") assuming a maximum of eight variables to be compared}

\item{outlier_shape}{is the optional shape to replace the outliers in the boxplot. To show no outliers use NA. See \code{\link[ggplot2:aes_linetype_size_shape]{shape}} for shape options}

\item{x_axis_name}{is the name (character string) to be passed to the x-axis title. Default is "Outcome distribution" and allows allow the user to add a customized axis title}

\item{y_axis_name}{is the name (character string) to be passed to the y-axis title. Default is NULL to allow the user to add a customized axis title. If a name is not provided the title will be "Number of points in bin" for the \code{hist_simple_overlay} method and "Density estimate" for all other plot options}

\item{base_size}{is the base text size to be used for the plot. The default is 11, this is the \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}} default}

\item{...}{accepts arguments to be passed to \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}}}
}
\value{
This function returns a plot of classes \code{'gg'}, 
and \code{'ggplot'}. This allows the user to
continue editing some features of the plots through the syntax 
\code{'+'}.
}
\description{
Several plotting options for distribution outputs
}
\examples{
##############################################################
# Example 1 (Creating the estimate from the command line):
#############################################################
# Create the estimate object:

variable = c("revenue", "costs")
distribution = c("norm", "norm")
lower = c(10000,  5000)
upper = c(100000, 50000)
costBenefitEstimate <- as.estimate(variable, distribution, lower, upper)

# (a) Define the model function without name for the return value:

profit1 <- function(x) {
  x$revenue - x$costs
  return(list(Revenues = x$revenue,
              Costs = x$costs))
}

# Perform the Monte Carlo simulation:

predictionProfit1 <- mcSimulation(estimate = costBenefitEstimate,
                                  model_function = profit1,
                                  numberOfModelRuns = 10000,
                                  functionSyntax = "data.frameNames")


# Plot the distributions

plot_distributions(mcSimulation_object = predictionProfit1, vars = c("Revenues", "Costs"),
         method = "smooth_simple_overlay")

plot_distributions(mcSimulation_object = predictionProfit1, vars = c("Revenues", "Costs"),
         method = "hist_simple_overlay", bins = 30)

plot_distributions(mcSimulation_object = predictionProfit1, vars = c("Costs"),
         method = "hist_simple_overlay", binwidth = 1000)

plot_distributions(mcSimulation_object = predictionProfit1, vars = c("Revenues", "Costs"),
         method = "boxplot_density", outlier_shape = 3)
 

}
\references{
Do, Hoa, Eike Luedeling, and Cory Whitney. “Decision Analysis of Agroforestry Options Reveals Adoption Risks for Resource-Poor Farmers.” Agronomy for Sustainable Development 40, no. 3 (June 2020): 20. \doi{10.1007/s13593-020-00624-5}.
Lanzanova, Denis, Cory Whitney, Keith Shepherd, and Eike Luedeling. “Improving Development Efficiency through Decision Analysis: Reservoir Protection in Burkina Faso.” Environmental Modelling & Software 115 (May 1, 2019): 164–75. \doi{10.1016/j.envsoft.2019.01.016}.
Ruett, Marius, Cory Whitney, and Eike Luedeling. “Model-Based Evaluation of Management Options in Ornamental Plant Nurseries.” Journal of Cleaner Production 271 (June 2020): 122653. \doi{10.1016/j.jclepro.2020.122653}.
}
\author{
Eduardo Fernandez (\email{efernand@uni-bonn.de})

Cory Whitney (\email{cory.whitney@uni-bonn.de})
}
\keyword{Monte-Carlo}
\keyword{NPV}
\keyword{decision-analysis}
\keyword{decisionSupport}
\keyword{net-present-value}
\keyword{risk}
\keyword{uncertainty}
