% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdist90ci_exact.R
\name{rdist90ci_exact}
\alias{rdist90ci_exact}
\title{90\%-confidence interval based univariate random number generation (by exact parameter 
calculation).}
\usage{
rdist90ci_exact(distribution, n, lower, upper)
}
\arguments{
\item{distribution}{\code{character}; A character string that defines the univariate distribution
to be randomly sampled. For possible options cf. section Details.}

\item{n}{Number of generated observations.}

\item{lower}{\code{numeric}; lower bound of the 90\% confidence interval.}

\item{upper}{\code{numeric}; upper bound of the 90\% confidence interval.}
}
\value{
A numeric vector of length \code{n} with the sampled values according to the chosen 
  distribution.
  
  In case of \code{distribution="const"}, viz. the deterministic case, the function returns: 
  \code{rep(lower, n).}
}
\description{
This function generates random numbers for a set of univariate parametric distributions from  
given 90\% confidence interval.  Internally, this is achieved by exact, i.e. analytic, calculation
of the parameters for the individual distribution from the given 90\% confidence interval.
}
\details{
The following table shows the available distributions and their identification 
 (option: \code{distribution}) as a character string:
 \tabular{lll}{
 \bold{\code{distribution}} \tab \bold{Distribution Name}      \tab \bold{Requirements}\cr
 \code{"const"}             \tab Deterministic case            \tab \code{lower == upper}\cr
 \code{"norm"}              \tab \link{Normal}                 \tab \code{lower < upper} \cr
 \code{"lnorm"}             \tab \link[=Lognormal]{Log Normal} \tab \code{0 < lower < upper} \cr
 \code{"unif"}              \tab \link{Uniform}                \tab \code{lower < upper}
 }
 \subsection{Parameter formulae}{
   We use the notation: \eqn{l}\code{=lower} and \eqn{u}=\code{upper}; 
   \eqn{\Phi} is the cumulative distribution function of the standard normal distribution and 
   \eqn{\Phi^{-1}}{\Phi^(-1)} its inverse, which is the quantile function of the standard normal 
   distribution.
   \describe{
     \item{\code{distribution="norm":}}{The formulae for \eqn{\mu} and \eqn{\sigma}, viz. the 
     mean and standard deviation, respectively, of the normal distribution are
     \eqn{\mu=\frac{l+u}{2}}{\mu=(l+u)/2} and
     \eqn{\sigma=\frac{\mu - l}{\Phi^{-1}(0.95)}}{\sigma=(\mu - l)/\Phi^(-1)(0.95)}.
     }
     \item{\code{distribution="unif":}}{For the minimum \eqn{a} and 
   maximum \eqn{b} of the uniform distribution \eqn{U_{[a,b]}}{U([a,b])} it holds that
                                         \eqn{a = l - 0.05 (u - l)
                                             }{a = l - 0.05 (u - l)} and 
                                         \eqn{b= u + 0.05 (u - l)
                                             }{b = u + 0.05 (u - l)}.
     }
      \item{\code{distribution="lnorm":}}{The density of the log normal distribution is 
            \eqn{ f(x) = \frac{1}{ \sqrt{2 \pi} \sigma x } \exp( - \frac{( \ln(x) - \mu )^2 %
            }{
            2 \sigma^2}) }{f(x)=1/((2 \pi)^(1/2)\sigma x) exp(-1/2(((ln(x)-\mu)/\sigma)^2))
            } for \eqn{x > 0} and \eqn{f(x) = 0} otherwise.
            Its parameters are determined by the confidence interval via 
            \eqn{\mu = \frac{\ln(l) + \ln(u)}{2}
            }{
            \mu = (ln(l)+ln(u))/2
            } and 
            \eqn{\sigma = \frac{1}{\Phi^{-1}(0.95)} ( \mu - \ln(l) )
            }{
            \sigma =  (\mu-ln(l))/\Phi^(-1)(0.95)
            }. Note the correspondence to the formula for the normal distribution.
      }
   }
 }
}
\examples{
# Generate uniformly distributed random numbers:
lower=3
upper=6
hist(r<-rdist90ci_exact(distribution="unif", n=10000, lower=lower, upper=upper),breaks=100)
print(quantile(x=r, probs=c(0.05,0.95)))
print(summary(r))

# Generate log normal distributed random numbers:
hist(r<-rdist90ci_exact(distribution="lnorm", n=10000, lower=lower, upper=upper),breaks=100)
print(quantile(x=r, probs=c(0.05,0.95)))
print(summary(r))
}
