% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scale_data.R
\name{get_scale_data}
\alias{get_scale_data}
\title{Get geological timescale data}
\usage{
get_scale_data(name, true_colors = TRUE)
}
\arguments{
\item{name}{The name of the desired timescale.}

\item{true_colors}{Return original international time scale colors? (as
opposed to custom Macrostrat plotting colors)}
}
\value{
A \code{data.frame} with the following columns:
\item{name}{the names of the time intervals}
\item{max_age}{the oldest boundaries of the time intervals, in millions of
years}
\item{min_age}{the youngest boundaries of the time intervals, in millions
of years}
\item{abbr}{either traditional abbreviations of the names of the time
intervals (if they exist) or custom abbreviations created with R}
\item{color}{hex color codes associated with the time intervals (if
applicable)}
\item{lab_color}{default label colors for the time interals, either white
or black, whichever has better contrast with the background color, based
on \href{https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en}{recommendations by the International Telecommunication Union}}
}
\description{
This function takes a name of a geological timescale and returns data for the
timescale. Valid names include those of built-in \code{data.frames} (\code{\link[=periods]{periods()}},
\code{\link[=epochs]{epochs()}}, \code{\link[=stages]{stages()}}, \code{\link[=eons]{eons()}}, or \code{\link[=eras]{eras()}}), partial matches of those
names (e.g., "per" or "age"), and partial or exact matches to those hosted
by Macrostrat (see Details below). Note that the colors in the built-in
\code{data.frames} are according to the Commission for the Geological Map of the
World. If you would like to obtain custom Macrostrat colors that are better
for mapping, you should specify the full name of a timescale (e.g.,
"international periods") and set \code{true_colors} to \code{FALSE}. Note that these
colors only vary for the Precambrian.
}
\details{
The following timescales are available from the Macrostrat API as of
2025-11-19:
\itemize{
\item international ages
\item international epochs
\item international periods
\item calcareous nannoplankton zones
\item New Zealand ages
\item custom COSUNA
\item North American land mammal ages
\item international intervals
\item COSUNA
\item international eras
\item international eons
\item Trilobite Zonation - Laurentia
\item Conodont Zonation
\item North American Regional
\item Ammonite Zonation - Boreal
\item Ammonite Zonation - Western Interior
\item international intervals covering all time
\item Scotese Reconstruction
\item Geomagnetic Polarity Chron
\item Geomagnetic Polarity Subchron
\item Planktic foraminiferal Primary Biozones
\item Planktic foraminiferal Secondary Biozones
\item Planktic foraminiferal datums
\item Martian Periods
\item Martian Epochs
\item Cretaceous Planktic foraminifer zonations
\item Low latitude radiolarian zonation
\item Neogene North Pacific Diatom Biochronology
\item Neogene North Pacific Diatom Biochronology Subzones
\item Siberian Regional
\item Australian Regional
\item Western Europe Regional
\item Russian Platform Regional Stages
\item Russian Precambrian Eras
\item Russian Precambrian Eons
\item Russian Epochs
\item Russian Stages
}

The most up-to-date list can be found via the Macrostrat API \href{https://macrostrat.org/api/defs/timescales?all}{here}.
}
