% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regL1_het.R
\name{regL1_het}
\alias{regL1_het}
\title{Fitting Heteroscedastic Linear L1 Models}
\usage{
regL1_het(
  x,
  y,
  groups,
  na.action = stats::na.omit,
  method = "br",
  model = TRUE,
  tolerance = 0.001,
  max_iteration = 2000,
  ...
)
}
\arguments{
\item{x}{the regression design matrix.}

\item{y}{the regression response vector.}

\item{groups}{vector with the group index associated with the observation, observations with the same index belong to the same group.}

\item{na.action}{a function to filter missing data. This is applied to the model.frame after any subset argument has been used. The default (with na.fail) is to create an error if any missing values are found. A possible alternative is na.omit, which deletes observations that contain one or more missing values.}

\item{method}{the algorithmic method used to compute the fit. There are several options: "br", "fn", "pfn", "sfn", "fnc", "conquer", "pfnb", "qfnb", "ppro" and "lasso". See \code{\link[quantreg]{rq}} for more details.}

\item{model}{if TRUE then the model frame is returned. This is essential if one wants to call summary subsequently.}

\item{tolerance}{threshold that determines when the iterative algorithm should stop.}

\item{max_iteration}{maximum number of iterations.}

\item{...}{additional arguments for the fitting routines (see \code{\link[quantreg]{rq.fit.br}} and \code{\link[quantreg]{rq.fit.fnb}}, etc. and the functions they call).}
}
\value{
A fitted heteroscedastic L1 linear regression model object.
}
\description{
This function fits an groupwise heteroscedastic L1 regression model using the \code{\link[quantreg]{rq}} function from the 'quantreg' package.
}
\details{
L1 regression is an important particular case of quantile regression, so this function inherits from the "rq" class of the \code{quantreg} package.
}
\examples{
set.seed(123)
x1 = matrix(rnorm(20), ncol = 2)
y1 = x1[, 1] + x1[, 2] + rlaplace(10, 0, 5)
x2 = matrix(rnorm(20), ncol = 2)
y2 = x2[, 1] + x2[, 2] + rlaplace(10, 0, 10)
x3 = matrix(rnorm(20), ncol = 2)
y3 = x3[, 1] + x3[, 2] + rlaplace(10, 0, 15)
x4 = matrix(rnorm(20), ncol = 2)
y4 = x4[, 1] + x4[, 2] + rlaplace(10, 0, 20)
x5 = matrix(rnorm(20), ncol = 2)
y5 = x5[, 1] + x5[, 2] + rlaplace(10, 0, 30)

y = c(y1, y2, y3, y4, y5)
x = rbind(x1, x2, x3, x4, x5)
group_index = c(rep(1,10),rep(2,10),rep(3,10),rep(4,10),rep(5,10))
# Fits a heteroscedastic linear regression L1 model
mod1 = regL1_het(x, y, group_index)

}
