% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical.R
\name{quantile.Categorical}
\alias{quantile.Categorical}
\title{Determine quantiles of a Categorical discrete distribution}
\usage{
\method{quantile}{Categorical}(x, probs, ...)
}
\arguments{
\item{x}{A \code{Categorical} object created by a call to \code{\link[=Categorical]{Categorical()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Categorical(1:3, p = c(0.4, 0.1, 0.5))
X

Y <- Categorical(LETTERS[1:4])
Y

random(X, 10)
random(Y, 10)

pdf(X, 1)
log_pdf(X, 1)

cdf(X, 1)
quantile(X, 0.5)

# cdfs are only defined for numeric sample spaces. this errors!
# cdf(Y, "a")

# same for quantiles. this also errors!
# quantile(Y, 0.7)
}
