#' @title Margalev index
#'
#' @description Computes Margalev's index
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Margalev index.
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' margalev(Qesem_s$HU)
#'
#' @export
margalev  <- function(x){
  x <- stats::na.omit(x)
  stopifnot(is.numeric(x))
  x <- ifelse(x==0, NA, x)
  x <- stats::na.omit(x)
  stopifnot(
    all(x >0),
    isTRUE(all.equal(x, round(x)))
  )
  return((length(x)-1)/log(sum(x)))
}
