% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opti_helpers.R
\name{max_ratios_summary}
\alias{max_ratios_summary}
\title{Find the max ratio of probabilities between two permutations for each matched set.}
\usage{
max_ratios_summary(Z, index, gamma)
}
\arguments{
\item{Z}{A length N vector of  observed doses.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}
}
\value{
A vector of length equaling the number of unique indices that contains
the maximum ratio between any two permutations for each of the matched sets.
}
\description{
Find the max ratio of probabilities between two permutations for each matched set.
}
\examples{
# A vector of observed doses
doses <- c(0, 0.1, 0.4, 0.8, 1)
matched_set <- c(1, 1, 1, 2, 2)
ratios <- max_ratios_summary(Z = doses, index = matched_set, gamma = 1)
}
