% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FS.wrda.R
\name{FS.wrda}
\alias{FS.wrda}
\title{Forward selection of predictor variables using wrda or cca0}
\usage{
\method{FS}{wrda}(
  mod,
  ...,
  consider = NULL,
  permutations = 999,
  n_axes = "all",
  initial_model = "1",
  factor2categories = TRUE,
  test = TRUE,
  threshold_P = 0.1,
  PvalAdjustMethod = "holm",
  max_step = 10,
  verbose = FALSE
)
}
\arguments{
\item{mod}{initial wrda or cca0 model with at least on predictor variable,}

\item{...}{unused.}

\item{consider}{character vector of names in \code{mod$data}
to consider for addition.}

\item{permutations}{a list of control values for the permutations as
returned by the function \code{\link[permute]{how}}, or the number of 
permutations required (default 999), or a permutation matrix where each row
gives the permuted indices.}

\item{n_axes}{number of eigenvalues to select upon.
The sum of \code{n_axes} eigenvalues is taken as criterion.
Default \code{"full"} for selection without dimension reduction to 
\code{n_axes}.
If \code{n_axes =1}, selection is on the first eigenvalue 
for selection of variables that form an optimal one-dimensional model.}

\item{initial_model}{character specifying what should be inside 
\code{Condition()}. Default: \code{"1"} (nothing, the intercept only).
Examples: \code{"region"} for a within-region analysis or
\code{"A*B"} for a within analysis specified by the interaction 
of factors \code{A} and \code{B}, with \code{region, A, B} 
in the data.}

\item{factor2categories}{logical, default \code{TRUE}, to convert
factors to their categories (set(s) of indicator values). 
If \code{FALSE}, the selection uses, the fit of a factor
divided by its number of categories minus 1.}

\item{test}{logical; default: \code{TRUE}.}

\item{threshold_P}{significance level, after adjustment for testing 
multiplicity, for addition of a variable to the model.}

\item{PvalAdjustMethod}{method for correction for multiple testing 
in  \code{\link[stats]{p.adjust}}, default \code{"holm"}, which
is an improved version Bonferroni.}

\item{max_step}{maximal number of variables selected.}

\item{verbose}{show progress, default: \code{TRUE}.}
}
\value{
list with three elements: \code{final...} with selected variables
 and \code{model_final} and \code{process} with account of the selection process 
 If \code{is.numeric(n_axes)}, then the variance in the returned table is
 the sum of the n_axes eigenvalues of the current model
 (all variables so far included).
}
\description{
Forward selection of predictor variables using wrda or cca0
}
\details{
The selection is on the basis of the additional fit (inertia) of a variable 
given the variables already in the model.

The names in \code{consider} may include 
transformations of predictor variables, such as \code{log(.)},
if \code{consider} does not include factors or if \code{factor2categories=FALSE}.
If \code{consider} does include factors, such transformations
give in a error in the default setting (\code{factor2categories=TRUE}).
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites
abun <- dune_trait_env$comm[, -1] # must delete "Sites"

mod <- dc_CA(formulaEnv = abun ~ Moist + Mag,
             formulaTraits = ~ F + R + N + L,
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)

# selection of traits with environmental model of mod (~ Moist+Mag)
out1 <- FS(mod, consider = c("F", "R", "N", "L"), 
           select = "traits", verbose = FALSE) 

names(out1)
out1$finalWithOneExtra
out1$model_final

# selection of environmental variables with trait model of mod (~ F + R + N + L)
out2 <- FS(mod, consider =  c("A1", "Moist", "Mag", "Use", "Manure"), 
           select= "env", verbose = FALSE) 

names(out2)
out2$finalWithOneExtra
out2$model_final

# selection of environmental variables without a trait model 
# i.e. with a single constraint
mod3 <- cca0(mod$data$Y ~ Moist, data = mod$data$dataEnv)
out3 <- FS(mod3, consider = c("A1", "Moist", "Mag", "Use", "Manure"), 
           threshold_P = 0.05)

out3$finalWithOneExtra
out3$model_final

# selection of traits without an environmental model 
#                         i.e. with a single constraint
tY <- t(mod$data$Y)

mod4 <- cca0(tY ~ L, data = mod$data$dataTraits)

names(mod$data$dataTraits)
out4 <- FS(mod4, 
           consider =  c("SLA", "Height", "LDMC", "Seedmass", "Lifespan", 
                         "F", "R", "N", "L"))

out4$finalWithOneExtra
out4$model_final
}
\seealso{
\code{\link{cca0}}, \code{\link{wrda}} and 
\code{\link{FS.dcca}}
}
