% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.dcca.R
\name{fitted.dcca}
\alias{fitted.dcca}
\title{Fitted values of double-constrained correspondence analysis (dc-CA)}
\usage{
\method{fitted}{dcca}(object, ..., type = c("CWM", "SNC", "response"), rank = "full")
}
\arguments{
\item{object}{return value of \code{\link{dc_CA}}.}

\item{...}{Other arguments passed to the function (currently ignored).}

\item{type}{type of prediction, \code{c( "CWM","SNC", "response")} 
for environmental values, values of traits, 
response (expected abundance).}

\item{rank}{rank (number of axes to use). Default "full" for all axes 
(no rank-reduction).}
}
\value{
a matrix with fitted value. The exact content of the matrix 
depends on the \code{type} of fits that are asked for.
}
\description{
Community weighted means (CWM) and species-niche centroids (SNC),
as fitted (in full or reduced rank) from the environmental data and
trait data, respectively, and  
the fitted response from trait and environment data.
}
\details{
If \code{type="response"} the rowsums of \code{object$data$Y} are used
to scale the fit to these sums. Many of the predicted response values may 
be negative,  indicating expected absences (0) or small expected response 
values.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Condition(Manure),
             formulaTraits = ~ SLA + Height + LDMC + Condition(Seedmass) + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits, 
             verbose = FALSE)
# fit the mean traits at each site (20x6),
# that is CWM at each site
CWM.traits <- fitted(mod, type = "CWM")
head(CWM.traits)

# fit the mean environment for each species (28x8)
# that is SNC of each species
SNC.env <- fitted(mod, type = "SNC")
head(SNC.env)

fit.resp <- fitted(mod, type = "response")
# fitted often gives negative values and dc_CA cannot have negatives in the 
# response so, modify fit.resp,
# which gives about similar eigenvalues as the original data
fit.resp[fit.resp < 0] <- 0
mod3 <- dc_CA(formulaEnv = mod$formulaEnv,
              formulaTraits = mod$formulaTraits,
              response = fit.resp, 
              dataEnv = dune_trait_env$envir,
              dataTraits = dune_trait_env$traits, 
              verbose = FALSE)
mod3$eigenvalues / mod$eigenvalues

}
