% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{create_traitset}
\alias{create_traitset}
\title{Takes an airr clone object and returns BEAST2 XML for a trait/traitSet from a column}
\usage{
create_traitset(
  clone,
  trait_name,
  column,
  id,
  trait_data_type = NULL,
  isSet = FALSE,
  include_germline_as_tip = FALSE
)
}
\arguments{
\item{clone}{an \code{airrClone} object}

\item{trait_name}{name of the trait}

\item{column}{column in the clone data to use for the trait}

\item{id}{unique identifer for this analysis}

\item{trait_data_type}{optional data type for the trait}

\item{isSet}{is this a traitSet (TRUE) or a trait (FALSE)?}

\item{include_germline_as_tip}{include the germline as a tip}
}
\value{
String of XML of the trait or traitSet
}
\description{
Takes an airr clone object and returns BEAST2 XML for a trait/traitSet from a column
}
