% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{getSkylines}
\alias{getSkylines}
\title{Make data frames for Bayesian skyline plots}
\usage{
getSkylines(
  clones,
  dir,
  id,
  time,
  burnin = 10,
  bins = 100,
  verbose = 0,
  forward = TRUE,
  nproc = 1,
  max_height = c("min", "median", "mean", "max")
)
}
\arguments{
\item{clones}{clone tibble}

\item{dir}{directory of BEAST trees file}

\item{id}{unique identifer for this analysis}

\item{time}{name of time column}

\item{burnin}{Burnin percent (default 10)}

\item{bins}{number of bins for plotting}

\item{verbose}{if 1, print name of clones}

\item{forward}{plot in forward or (FALSE) backward time?}

\item{nproc}{processors for parallelization (by clone)}

\item{max_height}{max height to use (min, median, mean, max)}
}
\value{
Bayesian Skyline values for given clone
}
\description{
\code{makeSkylines}
}
\details{
Burnin set from readBEAST or getTrees
}
