% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{write_clones_to_xmls}
\alias{write_clones_to_xmls}
\title{Wrapper to write multiple clones to XML files}
\usage{
write_clones_to_xmls(
  data,
  id,
  trees = NULL,
  time = NULL,
  trait = NULL,
  template = NULL,
  outfile = NULL,
  replacements = NULL,
  trait_list = NULL,
  mcmc_length = 1e+06,
  log_every = 1000,
  include_germline_as_root = FALSE,
  include_germline_as_tip = FALSE,
  germline_range = c(-10000, 10000),
  tree_states = FALSE,
  start_edge_length = 100,
  start_date = NULL,
  max_start_date = NULL,
  ...
)
}
\arguments{
\item{data}{a list of \code{airrClone} objects}

\item{id}{identifer for this analysis}

\item{trees}{optional list of starting trees, either phylo objects or newick strings}

\item{time}{name of column representing sample time}

\item{trait}{name of column representing a trait}

\item{template}{XML template}

\item{outfile}{output file path prefix}

\item{replacements}{list of additional replacements to make in the template}

\item{trait_list}{list of all possible trait values}

\item{mcmc_length}{number of MCMC iterations}

\item{log_every}{frequency of states logged. \code{auto} will divide mcmc_length by log_target}

\item{include_germline_as_root}{include germline in analysis as root?}

\item{include_germline_as_tip}{include germline in analysis as tip?}

\item{germline_range}{possible date range of germline}

\item{tree_states}{use states in the starting tree?}

\item{start_edge_length}{edge length to use for all branches in starting tree}

\item{start_date}{starting date to use as prior, in forward time}

\item{max_start_date}{max starting date to use as prior, in forward time}

\item{...}{additional arguments for XML writing functions}
}
\value{
File paths of the written XML files
}
\description{
Wrapper to write multiple clones to XML files
}
