% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsemRTMB.R
\name{dsemRTMB}
\alias{dsemRTMB}
\title{Fit dynamic structural equation model}
\usage{
dsemRTMB(
  sem,
  tsdata,
  family = rep("fixed", ncol(tsdata)),
  estimate_delta0 = FALSE,
  log_prior = function(p) 0,
  control = dsem_control(),
  covs = colnames(tsdata)
)
}
\arguments{
\item{sem}{Specification for time-series structural equation model structure
including lagged or simultaneous effects.  See Details section in
\code{\link[dsem]{make_dsem_ram}} for more description}

\item{tsdata}{time-series data, as outputted using \code{\link[stats]{ts}}, with \code{NA}
for missing values.}

\item{family}{Character-vector listing the distribution used for each column of \code{tsdata}, where
each element must be \code{fixed} (for no measurement error),
\code{normal} for normal measurement error using an identity link,
\code{gamma} for a gamma measurement error using a fixed CV and log-link,
\code{bernoulli} for a Bernoulli measurement error using a logit-link, or
\code{poisson} for a Poisson measurement error using a log-link.
\code{family="fixed"} is default behavior and assumes that a given variable is measured exactly.
Other options correspond to different specifications of measurement error.}

\item{estimate_delta0}{Boolean indicating whether to estimate deviations from equilibrium in initial year
as fixed effects, or alternatively to assume that dynamics start at some stochastic draw away from
the stationary distribution}

\item{log_prior}{A user-provided function that takes as input the list of
parameters \code{out$obj$env$parList()} where \code{out} is the output from
\code{dsemRTMB()}, and returns the log-prior probability.  For example
\code{log_prior = function(p) dnorm( p$beta_z[1], mean=0, sd=0.1, log=TRUE)}
specifies a normal prior probability for the first path coefficient
with mean of zero and sd of 0.1.  Note that the user must load RTMB using
\code{library(RTMB)} prior to running the model.}

\item{control}{Output from \code{\link{dsem_control}}, used to define user
settings, and see documentation for that function for details.}

\item{covs}{optional: a character vector of one or more elements, with each element giving a string of variable
names, separated by commas. Variances and covariances among all variables in each such string are
added to the model. Warning: covs="x1, x2" and covs=c("x1", "x2") are not equivalent:
covs="x1, x2" specifies the variance of x1, the variance of x2, and their covariance,
while covs=c("x1", "x2") specifies the variance of x1 and the variance of x2 but not their covariance.
These same covariances can be added manually via argument \code{sem}, but using argument \code{covs} might
save time for models with many variables.}
}
\value{
An object (list) of class \code{dsem}, fitted using RTMB
}
\description{
Fits a dynamic structural equation model
}
\details{
\code{dsemRTMB} is interchangeable with \code{\link{dsem}}, but uses RTMB
instead of TMB for estimation.  Both are provided for comparison and
real-world comparison. See \code{?dsem} for more details
}
\examples{
# Define model
sem = "
  # Link, lag, param_name
  cprofits -> consumption, 0, a1
  cprofits -> consumption, 1, a2
  pwage -> consumption, 0, a3
  gwage -> consumption, 0, a3
  cprofits -> invest, 0, b1
  cprofits -> invest, 1, b2
  capital -> invest, 0, b3
  gnp -> pwage, 0, c2
  gnp -> pwage, 1, c3
  time -> pwage, 0, c1
"

# Load data
data(KleinI, package="AER")
TS = ts(data.frame(KleinI, "time"=time(KleinI) - 1931))
tsdata = TS[,c("time","gnp","pwage","cprofits",'consumption',
               "gwage","invest","capital")]

# Fit model
fit = dsemRTMB( sem=sem,
            tsdata = tsdata,
            estimate_delta0 = TRUE,
            control = dsem_control(quiet=TRUE) )

}
