% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsp_model.R, R/print.R
\name{dsp_spec}
\alias{dsp_spec}
\alias{print.dsp_spec}
\title{Model Specification}
\usage{
dsp_spec(family, model, ...)

\method{print}{dsp_spec}(x, ...)
}
\arguments{
\item{family}{A character string specifying the model family. Must be one of:
\itemize{
\item "gaussian": Gaussian family.
\item "negbinom": Negative binomial family.
}}

\item{model}{A character string specifying the model type:
\itemize{
\item \code{family} = "gaussian":
\itemize{
\item "changepoint": Change point detection with
Adaptive Bayesian Changepoint analysis and local Outlier (ABCO),
\item "smoothing": Bayesian smoothing,
\item "regression": Time-varying regression,
\item "bspline": Bayesian smoothing with B-spline for irregularly spaced or functional time-series.
}
\item \code{family} = "negbinom":
\itemize{
\item "smoothing": Bayesian smoothing.
}
}}

\item{...}{currently not used}

\item{x}{object of class dsp_spec from \code{\link[=dsp_spec]{dsp_spec()}}}
}
\value{
A list containing the model specification.
}
\description{
Method for creating dsp specification object prior to fitting.

Method for printing basic information about the model specification
}
\examples{
model_spec <- dsp_spec(family = "gaussian",
                      model = "changepoint")


print(model_spec)

}
