% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASV.R
\name{init_paramsASV_n}
\alias{init_paramsASV_n}
\title{Helper function for initializing parameters for ASV model with a nugget effect}
\usage{
init_paramsASV_n(data, evol_error, D)
}
\arguments{
\item{data}{the \code{T x 1} vector of time series observations.}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), 'BL' (Bayesian lasso), or 'NIG' (normal-inverse-gamma prior)}

\item{D}{degree of differencing (D = 1, or D = 2)}
}
\value{
a list containing 4 sets of parameters
\itemize{
\item s_p_error_term: matrix containing mean and the variance from 10-componenet gaussian mixture (Omori et al. 2007)
\item s_mu: a vector containing the posterior sample of log variance h,
\item s_evolParams0: a list containing posterior samples of parameters associated with the variance of first D observation of the log variance term, h.
\item s_evolParams: a list containing posterior samples parameters associated with the variance of D to the last observations of the log variance temr , h.
}
}
\description{
Helper function for initializing parameters for ASV model with a nugget effect
}
