% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_comment}
\alias{p_comment}
\title{Add a generic comment to the dtrackr history graph}
\usage{
p_comment(
  .data,
  .messages = .defaultMessage(),
  .headline = .defaultHeadline(),
  .type = "info",
  .asOffshoot = (.type == "exclusion"),
  .tag = NULL
)
}
\arguments{
\item{.data}{a dataframe which may be grouped}

\item{.messages}{a character vector of glue specifications. A glue
specification can refer to any grouping variables of .data, or any
variables defined in the calling environment, the \{.total\} of all rows,
the \{.count\} variable which is the count in each group and \{.strata\} a
description of the group}

\item{.headline}{a glue specification which can refer to grouping variables
of .data, or any variables defined in the calling environment, or the
\{.total\} variable (which is \code{nrow(.data)}) and \{.strata\} which is a
description of the grouping}

\item{.type}{one of "info","...,"exclusion": used to define formatting}

\item{.asOffshoot}{do you want this comment to be an offshoot of the main
flow (default = FALSE).}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the same .data dataframe with the history graph updated with the comment
}
\description{
A comment can be any kind of note and is added once for every current
grouping as defined by the \code{.message} field. It can be made context specific
by including variables such as \{.count\} and \{.total\} in \code{.message} which
refer to the grouped and ungrouped counts at this current stage of the
pipeline respectively. It can also pull in any global variable.
}
\examples{
library(dplyr)
library(dtrackr)
iris \%>\% track() \%>\% comment("hello {.total} rows") \%>\% history()
}
