% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble_to_matrix.r
\name{tibble_to_comm}
\alias{tibble_to_comm}
\alias{tibble_to_dist}
\alias{tibble_to_env}
\title{Convert a long tibble to a community matrix}
\usage{
tibble_to_comm(long.table, taxon, Abundance, sample.name)

tibble_to_dist(
  long.table,
  taxon,
  Abundance,
  sample.name,
  distance = "bray",
  transformation = NULL,
  ...
)

tibble_to_env(long.table, taxon, Abundance, sample.name, ...)
}
\arguments{
\item{long.table}{A tibble with sample, taxon, abundance, and metadata columns.}

\item{taxon}{Column containing taxa/OTU IDs (unquoted).}

\item{Abundance}{Column with counts/abundance values (unquoted).}

\item{sample.name}{Column with sample IDs (unquoted).}

\item{distance}{Distance metric to use (default = "bray").}

\item{transformation}{Optional transformation (e.g. "hellinger", "log"). See vegan::decostand documentation for a great explanation of all transformations}

\item{...}{Additional metadata columns to retain.}
}
\value{
A numeric matrix with taxa as columns and samples as row names.

A \code{dist} object.

A tibble of unique sample-level metadata.
}
\description{
Converts a long-format table of sequence counts into a wide community
matrix (samples × taxa) suitable for vegan or other community ecology tools.

Produces a distance matrix between samples using vegan's \code{vegdist()}.
Optionally applies a data transformation before distance calculation.

Returns the environmental data frame (sample metadata) from a long
sequence/OTU tibble by removing taxon and abundance columns.
}
\examples{
data("ASV_table")
 tibble_to_comm(ASV_table, 
                taxon = Hash,
                 Abundance = nReads,
                  sample.name = sample_name)
data("ASV_table")
tibble_to_dist(ASV_table,
               taxon = Hash,
               Abundance = nReads,
               sample.name = sample_name,
               distance = "bray",
               transformation = "hellinger")

data("ASV_table")
data("metadata")
dplyr::inner_join(ASV_table,metadata) |> 
tibble_to_env(taxon = Hash,
              Abundance = nReads, 
              sample.name = sample_name)

}
