% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{AICc}
\alias{AICc}
\alias{AICc.fcm}
\title{Corrected Akaike Information Criterion (AICc) for fcm objects}
\usage{
AICc(object, ...)

\method{AICc}{fcm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fcm}, created by \code{\link[=fcm]{fcm()}}.}

\item{...}{Currently unused.}
}
\value{
A numeric scalar giving the AICc value for the fitted model.
}
\description{
Compute the AICc value for a fitted \code{fcm} model using the formula:
\deqn{\mathrm{AICc} = \mathrm{AIC} + \frac{2p(p+1)}{n - p - 1}}
where \eqn{n} is the number of observations and \eqn{p} is the number of parameters.
}
\seealso{
\code{\link[=AIC.fcm]{AIC.fcm()}}, \code{\link[=BIC.fcm]{BIC.fcm()}}
}
