% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_iso3_codes_column}
\alias{add_iso3_codes_column}
\title{Add ISO-3 Codes to Country Data}
\usage{
add_iso3_codes_column(df, id_column, target_column = "iso3_code")
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{target_column}{Name of the output column. Defaults to "iso3_code".}
}
\value{
A data frame with an additional column containing the ISO-3 code.
}
\description{
Add ISO-3 Codes to Country Data
}
\examples{
# Convert country names to ISO3 codes
df <- data.frame(name = c("United States", "Canada", "Mexico"))
result <- add_iso3_codes_column(df, id_column = "name")

}
