% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-get_trackdata.R
\name{get_trackdata}
\alias{get_trackdata}
\alias{emu.track}
\title{Get trackdata from loaded emuDB}
\usage{
get_trackdata(
  emuDBhandle,
  seglist = NULL,
  ssffTrackName = NULL,
  cut = NULL,
  npoints = NULL,
  onTheFlyFunctionName = NULL,
  onTheFlyParams = NULL,
  onTheFlyOptLogFilePath = NULL,
  onTheFlyFunction = NULL,
  resultType = "tibble",
  consistentOutputType = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{seglist}{\code{tibble}, \code{\link{emuRsegs}} or \code{\link{emusegs}} 
object obtained by \code{\link{query}}ing a loaded emuDB}

\item{ssffTrackName}{The name of track that one wishes to extract (see 
\code{\link{list_ssffTrackDefinitions}} for the defined ssffTracks of the 
emuDB). If the parameter \code{onTheFlyFunctionName} is set, then 
this corresponds to the column name af the AsspDataObj (see
\code{wrassp::wrasspOutputInfos[[onTheFlyFunctionName]]$tracks} and 
\code{\link[wrassp]{wrasspOutputInfos}} - NOTE: \code{library(wrassp)} might be 
necessary to access the \code{wrasspOutputInfos} object without the \code{wrassp::} prefix). 
If the parameter \code{onTheFlyFunctionName} is set and this one isn't, then per default
the first track listed in the \code{wrassp::wrasspOutputInfos} is chosen 
(\code{wrassp::wrasspOutputInfos[[onTheFlyFunctionName]]$tracks[1]}).

\code{get_trackdata} has so called constant track names that are always available 
for every emuDB. The constant track names are:

\itemize{
\item{"MEDIAFILE_SAMPLES": refers to the audio sample values specified 
by the "mediafileExtension" entry of the DBconfig.json}
}}

\item{cut}{An optional cut time for segment data, ranges between 
0 and 1, a value of 0.5 will extract data only at the segment midpoint.}

\item{npoints}{An optional number of points to retrieve for each segment or event. 
For segments this requires the \code{cut} parameter to be set; if this is the 
case, then data is extracted around the resulting cut time. 
For events data is extracted around the event time. If npoints is an odd number, the 
samples are centered around the cut-time-sample; if not, they are skewed to the
right by one sample.}

\item{onTheFlyFunctionName}{Name of wrassp function that will perform the on-the-fly 
calculation (see \code{?wrassp} for a list of all the signal processing functions wrassp provides)}

\item{onTheFlyParams}{A \code{pairlist} of parameters that will be given to the function 
passed in by the \code{onTheFlyFunctionName} parameter. This list can easily be 
generated by applying the \code{formals} function to the on-the-fly function name and then setting the according 
parameter one wishes to change.}

\item{onTheFlyOptLogFilePath}{Path to optional log file for on-the-fly function}

\item{onTheFlyFunction}{pass in a function pointer. This function will be called with the path to the
current media file. It is required that the function returns a tibble/data.frame like object that contains
a column called \code{frame_time} that specifies the time point of each row. \code{get_trackdata} will then
extract the rows belonging to the current segment. This allows users to code their own function to be used with
\code{get_trackdata} and allows for most data formats to be used within an emuDB.}

\item{resultType}{Specify class of returned object. Either \code{"emuRtrackdata"}, 
\code{"trackdata"} or \code{"tibble"} == the default  (see \code{\link{trackdata}}, \code{\link{emuRtrackdata}} 
and \code{\link[tibble]{tibble}} for details about these objects).}

\item{consistentOutputType}{Prevent converting the output object to a \code{data.frame} 
depending on the \code{npoint} and \code{cut} arguments (only applies to output 
type "trackdata"). Set to \code{FALSE} if the following legacy \code{emu.track} output 
conversion behaviour is desired: If the \code{cut} parameter is not set (the default) an 
object of type \code{\link{trackdata}} is returned. If \code{cut} is set and \code{npoints} 
is not, or the seglist is of type event and npoints is not set, a \code{\link{data.frame}} is 
returned (see the \code{consistentOutputType} to change this behaviour).}

\item{verbose}{Show progress bars and further information}
}
\value{
object of type specified with \code{resultType}
}
\description{
Extract trackdata information from a loaded emuDB that 
corresponds to the entries in a segment list.
}
\details{
This function utilizes the wrassp package for signal processing and 
SSFF/audio file handling. It reads time relevant data from a given 
segment list (\code{\link{emuRsegs}} or \code{\link{emusegs}}), extracts the 
specified trackdata and places it into a 
trackdata object (analogous to the deprecated \code{emu.track}). This function
replaces the deprecated \code{emu.track} function. Note that an warning is issued
if the bundles in the \code{\link{emuRsegs}} or \code{\link{emusegs}} object 
have in-homogeneous sampling rates as this could lead to inconsistent/erroneous
\code{\link{trackdata}}, \code{\link{emuRtrackdata}} or \code{\link[tibble]{tibble}} result objects. For 
more information on the structural elements of an emuDB 
see the signal data extraction chapter of the EMU-SDMS manual 
(\url{https://ips-lmu.github.io/The-EMU-SDMS-Manual/chap-sigDataExtr.html}).
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# query loaded "ae" emuDB for all "i:" segments of the "Phonetic" level
sl = query(emuDBhandle = ae, 
           query = "Phonetic == i:")

# get the corresponding formant trackdata
td = get_trackdata(emuDBhandle = ae, 
                   seglist = sl, 
                   ssffTrackName = "fm")

# get the corresponding F0 trackdata
# as there is no F0 ssffTrack defined in the "ae" emuDB we will 
# calculate the necessary values on-the-fly
td = get_trackdata(emuDBhandle = ae, 
                   seglist = sl, 
                   onTheFlyFunctionName = "ksvF0")
                   
}

}
\seealso{
\code{\link{formals}}, \code{\link[wrassp]{wrasspOutputInfos}}, 
\code{\link{trackdata}}, \code{\link{emuRtrackdata}}
}
\keyword{misc}
