% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprofile.R
\name{rprofile}
\alias{rprofile}
\title{Function used to pass through code to the .Rprofile}
\usage{
rprofile(
  config,
  envir = getOption("envsetup.path.environment"),
  overwrite = TRUE
)
}
\arguments{
\item{config}{configuration object from config::get()}

\item{envir}{The environment to search for the path object. Defaults to the
value of \code{getOption("envsetup.path.environment")}.}

\item{overwrite}{logical indicating if sourcing of autos should overwrite an object in global if it already exists}
}
\value{
Called for its side effects.  Directory paths and autos are added to the search path based on your config.
}
\description{
Function used to pass through code to the .Rprofile
}
\examples{
# temp location to store configuration files
tmpdir <- tempdir()
print(tmpdir)

# Create an example config file
hierarchy <- "default:
  paths:
    data: !expr list(DEV = '/demo/DEV/username/project1/data',
                     PROD = '/demo/PROD/project1/data')
    output: !expr list(DEV = '/demo/DEV/username/project1/output',
                       PROD = '/demo/PROD/project1/output')
    programs: !expr list(DEV = '/demo/DEV/username/project1/programs',
                         PROD = '/demo/PROD/project1/programs')"

writeLines(hierarchy, file.path(tmpdir, "hierarchy.yml"))

rprofile(config::get(file = file.path(tmpdir, "hierarchy.yml")))
}
