% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_monthly_counts}
\alias{create_report_monthly_counts}
\title{Create monthly counts report}
\usage{
create_report_monthly_counts(data, diseases, y)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Character vector. Diseases to include in the report}

\item{y}{Integer. Report year}
}
\value{
Dataframe of monthly counts with one row per disease and one column
per month (Jan through Dec).
}
\description{
'create_report_monthly_counts' generates a data frame of monthly case
counts for each disease for a specific year, with months as columns.
}
\examples{
data <- data.frame(
  disease = c("A", "A", "B", "B"),
  year = c(2024, 2024, 2024, 2023),
  month = c(1, 2, 1, 4),
  counts = c(5, 7, 8, 9)
)
create_report_monthly_counts(data, diseases = c("A", "B", "C"), y = 2024)
}
