% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{format_epitrax_data}
\alias{format_epitrax_data}
\title{Format EpiTrax data for report generation}
\usage{
format_epitrax_data(data)
}
\arguments{
\item{data}{Dataframe. Must contain columns:
\itemize{
\item \code{patient_disease} (character, unchanged from EpiTrax export)
\item \code{patient_mmwr_year} (integer, unchanged from EpiTrax export)
\item \code{month} (integer, converted from \code{patient_mmwr_week} by \code{mmwr_week_to_month()})
}}
}
\value{
A standardized data frame with columns "disease", "month", "year", and "counts".
}
\description{
\code{format_epitrax_data} prepares the input EpiTrax data for use by report generation
functions in the package. It adds the \code{counts} column, renames columns to
standard names used by the package ("disease", "month", "year", "counts"),
and rearranges columns for consistency.
}
\examples{
df <- data.frame(
  patient_mmwr_year = c(2020L, 2020L),
  month = c(1, 2),
  patient_disease = c("A", "B")
)
df <- format_epitrax_data(df)
}
\seealso{
\code{\link[=mmwr_week_to_month]{mmwr_week_to_month()}}
}
