% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_month_counts}
\alias{get_month_counts}
\title{Get monthly counts for each disease}
\usage{
get_month_counts(data)
}
\arguments{
\item{data}{Dataframe. Must contain columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}
}
\value{
A dataframe with the aggregated monthly counts
}
\description{
\code{get_month_counts} aggregates disease counts by month and year. This is a helper
function used internally by report generation functions to summarize monthly
disease counts.
}
\examples{
df <- data.frame(
  disease = c("Flu", "Flu", "Measles"),
  year = c(2020, 2020, 2020),
  month = c(1, 1, 2),
  counts = c(5, 3, 2)
)
get_month_counts(df)
}
