% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_epitrax}
\alias{validate_epitrax}
\title{Validate EpiTrax object}
\usage{
validate_epitrax(epitrax, report.check = TRUE)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{report.check}{Logical indicating whether to check report-related fields.}
}
\value{
NULL if valid, otherwise throws an error.
}
\description{
\code{validate_epitrax} checks that the EpiTrax object is valid.
}
\examples{
epitrax <- structure(
  list(
    data = c(1,2,3),
    config = list(rounding_decimals = 2, generate_csvs = TRUE),
    report_diseases = list(internal = "internal_list", public = "public_list")
  ),
  class = "epitrax"
)
validate_epitrax(epitrax, report.check = TRUE)
}
