% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryNet.R, R/roxygen.R
\docType{class}
\name{as.network.Rcpp_UndirectedNet}
\alias{as.network.Rcpp_UndirectedNet}
\alias{as.network.Rcpp_DirectedNet}
\alias{plot.Rcpp_DirectedNet}
\alias{plot.Rcpp_UndirectedNet}
\alias{as.BinaryNet}
\alias{BinaryNet}
\alias{DirectedNet}
\alias{UndirectedNet}
\alias{Rcpp_DirectedNet-class}
\alias{Rcpp_UndirectedNet-class}
\title{Convert an Rcpp_UndirectedNet to a network object}
\usage{
\method{as.network}{Rcpp_UndirectedNet}(x, ...)

\method{as.network}{Rcpp_DirectedNet}(x, ...)

\method{plot}{Rcpp_DirectedNet}(x, ...)

\method{plot}{Rcpp_UndirectedNet}(x, ...)

as.BinaryNet(x, ...)
}
\arguments{
\item{x}{the object}

\item{...}{unused}
}
\value{
an undirected network object

a directed network object

No return value, invisibly NULL

No return value, invisibly NULL

either an Rcpp_UndirectedNet or Rcpp_DirectedNet object
}
\description{
Converts a native ernm network into a network object
from the network package.

Converts a native ernm network into a network object
from the network package.

`BinaryNet` covers ERNM's native network objects exposed via Rcpp modules:
`Rcpp_DirectedNet` and `Rcpp_UndirectedNet`. This page documents the classes
and common coercion/plot/subsetting methods.
}
\section{Classes}{

* `Rcpp_DirectedNet` – directed binary network
* `Rcpp_UndirectedNet` – undirected binary network
}

\section{Coercion}{

* `as.network()` – convert to a `network` object (package **network**)
* `as.BinaryNet()` – convert from a `network` (or return-as-is)
}

\section{Methods}{

* `plot()` – plot via `plot.network`
}

\examples{
edge_list <- matrix(c(1,3),ncol=2)
# create a network with an edge from 1 -> 3
ernm_net <- new(UndirectedNet,edge_list,5)

# convert to a network object from the network package
network_net <- as.network(ernm_net)
network_net
edge_list <- matrix(c(1,3),ncol=2)
# create a network with an edge from 1 -> 3
ernm_net <- new(DirectedNet,edge_list,5)

# convert to a network object from the network package
network_net <- as.network(ernm_net)
network_net

# create ring network with 5 vertices
edge_list <- matrix(c(1,2,2,3,3,4,4,5,5,1),ncol=2, byrow=TRUE)
ernm_net <- new(DirectedNet,edge_list,5)

# basic plot
plot(ernm_net)

# change vertex point size (see plot.network)
plot(ernm_net, vertex.cex=.5)

# create ring network with 5 vertices
edge_list <- matrix(c(1,2,2,3,3,4,4,5,5,1),ncol=2, byrow=TRUE)
ernm_net <- new(UndirectedNet,edge_list,5)

# basic plot
plot(ernm_net)

# change vertex point size (see plot.network)
plot(ernm_net, vertex.cex=.5)

data(samplike)

# convert Sampson's monks into a native ernm network
net <- as.BinaryNet(samplike)
net[["group"]]
net[1:5,1:5]

}
\seealso{
[network::network], [network::plot.network]
}
