% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaRep.R
\name{AlphaRep}
\alias{AlphaRep}
\title{Alpha repeatability}
\usage{
AlphaRep(cor.matrix, sample.size)
}
\arguments{
\item{cor.matrix}{Correlation matrix}

\item{sample.size}{Sample size used in matrix estimation}
}
\value{
Alpha repeatability for correlation matrix
}
\description{
Calculates the matrix repeatability using the equation in Cheverud 1996
Quantitative genetic analysis of cranial morphology in the cotton-top
(Saguinus oedipus) and saddle-back (S. fuscicollis) tamarins. Journal of Evolutionary Biology 9, 5-42.
}
\examples{
#For single matrices
cor.matrix <- RandomMatrix(10)
AlphaRep(cor.matrix, 10)
AlphaRep(cor.matrix, 100)
#For many matrices
mat.list <- RandomMatrix(10, 100)
sample.sizes <- floor(runif(100, 20, 50))
unlist(Map(AlphaRep, mat.list, sample.sizes))
}
\references{
Cheverud 1996 Quantitative genetic analysis of cranial morphology in the cotton-top
  (Saguinus oedipus) and saddle-back (S. fuscicollis) tamarins. Journal of Evolutionary Biology 9, 5-42.
}
\seealso{
\code{\link{MonteCarloStat}}, \code{\link{BootstrapRep}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{repeatability}
