% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_n.R
\name{data_n}
\alias{data_n}
\alias{data_n25}
\alias{data_nsq}
\alias{dn}
\alias{dn25}
\alias{dnsq}
\title{Generate Sequences of Sample Sizes}
\usage{
data_n(max, min = 5)

data_nsq(max, min = 5)

data_n25(max, min = 5)

dn(max, min = 5)

dn25(max, min = 5)

dnsq(max, min = 5)
}
\arguments{
\item{max}{Integer. Maximum sample size.}

\item{min}{Integer. Minimum sample size (default: \code{5}).}
}
\value{
An integer vector of sample sizes satisfying the criteria.
}
\description{
Generate sequences of integers representing sample sizes within a specified range.

Functions support two specialized sequences:
\itemize{
\item \code{data_nsq} / \code{dnsq}: sample sizes that are perfect squares.
\item \code{data_n25} / \code{dn25}: sample sizes divisible only by 2 and 5.
}
}
\examples{
data_n(10)
data_nsq(1000)
data_n25(1000)
}
