% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ICs.R
\name{add_ICs}
\alias{add_ICs}
\title{adds information criteria to the @IC slot of an object of
 class \link{passed_exRa-class}}
\usage{
add_ICs(obj, ignoreCores = 1)
}
\arguments{
\item{obj}{an object of class \link{passed_exRa-class}}

\item{ignoreCores}{a numeric value for the number of virtual CPU cores
(threads)to hold out in computing the information criteria.}
}
\value{
an object of \link{passed_exRa-class}.
}
\description{
adds information criteria to the @IC slot of an object of
 class \link{passed_exRa-class}
}
\examples{
\donttest{
  library(exhaustiveRasch)
  data(ADL)
  passed <- exhaustive_tests(dset= ADL[c(1:4,7,12,14)],
    modelType= "RM", scale_length= 5, alpha=0.05,
    tests=c("test_LR", "test_itemfit", "test_respca"),
    splitcr_LR = ADL[,17], itemfit_param =
      itemfit_control(use.pval=FALSE, upperMSQ=1.5, lowerMSQ=0.5),
    estimation_param= estimation_control(
      est="psychotools"), verbose=FALSE)
  passed <- add_ICs(passed)
}
}
