% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ez_fix_rate_plot.R
\name{ez_fix_rate_plot}
\alias{ez_fix_rate_plot}
\title{Plot Fix Rate Timelines for Each Individual}
\usage{
ez_fix_rate_plot(
  data,
  date_breaks = NULL,
  date_format = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{data}{A data frame or `sf` object with columns `id` and `timestamp`.}

\item{date_breaks}{Optional. Spacing of x-axis breaks (e.g., `"1 month"`, `"2 weeks"`). If `NULL`, ggplot2 chooses automatically.}

\item{date_format}{Optional. Format string for x-axis date labels (e.g., "\%b \%Y", "\%d-\%m"). If `NULL`, ggplot2 chooses automatically.}

\item{start_date}{Optional. A `Date` or string (e.g., `"2024-01-01"`). Filters out fixes before this date.}

\item{end_date}{Optional. A `Date` or string (e.g., `"2024-12-31"`). Filters out fixes after this date.}
}
\value{
A `ggplot` object showing fix timelines per individual.
}
\description{
Creates a timeline plot showing fix events as horizontal tick marks for each individual.
This allows a quick visual assessment of tracking effort, fix density, and coverage gaps.
}
\examples{
df <- data.frame(
  id = rep(c("a", "b"), each = 3),
  timestamp = as.POSIXct(c("2025-01-01", "2025-01-02", "2025-01-03",
                           "2025-01-01", "2025-01-05", "2025-01-06"))
)
ez_fix_rate_plot(df)

}
